/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman;

import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskContextMenu;
import filenet.vw.apps.taskman.VWTaskScopeTree;
import java.awt.AWTException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

class VWScopeTreeMouseAndKeyAdapter
extends MouseAdapter
implements KeyListener {
    private VWTaskScopeTree m_scopeTree = null;
    private static Robot robot = null;

    public VWScopeTreeMouseAndKeyAdapter(VWTaskScopeTree scopeTree) {
        this.m_scopeTree = scopeTree;
    }

    public void keyTyped(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        switch (event.getKeyCode()) {
            case 121: {
                int row;
                Rectangle rect;
                JTree tree;
                TreePath path;
                int modifiers = event.getModifiers();
                if ((modifiers & 1) == 0) break;
                robot.keyPress(27);
                robot.keyRelease(27);
                int x = 10;
                int y = 10;
                if (event.getSource() instanceof JTree && (path = (tree = (JTree)event.getSource()).getSelectionPath()) != null && (rect = tree.getRowBounds(row = tree.getRowForPath(path))) != null) {
                    x = rect.x + 2 * rect.width / 3;
                    y = rect.y + 2 * rect.height / 3;
                }
                this.createPopup(event.getSource(), x, y);
            }
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void mousePressed(MouseEvent evt) {
        int selRow = this.m_scopeTree.getRowForLocation(evt.getX(), evt.getY());
        this.m_scopeTree.setSelectionRow(selRow);
        if (evt.isPopupTrigger()) {
            Object obj = evt.getSource();
            Point p = evt.getPoint();
            this.createPopup(obj, p.x, p.y);
        }
    }

    public void mouseReleased(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            Object obj = evt.getSource();
            Point p = evt.getPoint();
            this.createPopup(obj, p.x, p.y);
        }
    }

    public void mouseClicked(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            Object obj = evt.getSource();
            Point p = evt.getPoint();
            this.createPopup(obj, p.x, p.y);
        }
    }

    private void createPopup(Object source, int x, int y) {
        VWTaskContextMenu contextMenu = null;
        VWTaskBaseNode taskNode = null;
        TreePath selPath = this.m_scopeTree.getPathForLocation(x, y);
        if (selPath == null) {
            return;
        }
        taskNode = (VWTaskBaseNode)selPath.getLastPathComponent();
        contextMenu = new VWTaskContextMenu(taskNode, this.m_scopeTree);
        contextMenu.show((JTree)source, x, y);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    robot = new Robot();
                }
                catch (AWTException aWTException) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

